VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Connect"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Description = "Restore Project Add-In"
Option Explicit

Implements IDTExtensibility

Public VBInstance As VBIDE.VBE

Private mcbMenuCommandBarCtrl As Office.CommandBarControl
Private WithEvents MenuHandler As CommandBarEvents
Attribute MenuHandler.VB_VarHelpID = -1
Private gbRestore As Boolean

Private Const STR_RELOAD = "Reload last project on startup"
Private Const STR_NORELOAD = "Don't reload last project on startup"
Private Const STR_APP = "RestoreAddin"
Private Const STR_SECTION = "Parameters"
Private Const STR_KEY = "Reload"
Private Const STR_VB5 = "Software\Microsoft\Visual Basic\5.0"
Private Const BMP_NORELOAD = 100
Private Const BMP_RELOAD = 101

Private Sub IDTExtensibility_OnConnection(ByVal VBInst As Object, ByVal ConnectMode As vbext_ConnectMode, ByVal AddInInst As VBIDE.AddIn, custom() As Variant)
    
    'Save the vb instance
    Set VBInstance = VBInst
    
    'Add Add-In to Tools menu
    Set mcbMenuCommandBarCtrl = VBInstance.CommandBars("Tools").Controls.Add(before:=3)
    mcbMenuCommandBarCtrl.BeginGroup = True
    
    'Set global option variable
    gbRestore = GetSetting(STR_APP, STR_SECTION, STR_KEY, "1") = "1"
    If gbRestore Then
        mcbMenuCommandBarCtrl.Caption = STR_NORELOAD
        'Load menu icon
        Clipboard.SetData LoadResPicture(BMP_RELOAD, vbResBitmap)
    Else
        mcbMenuCommandBarCtrl.Caption = STR_RELOAD
        Clipboard.SetData LoadResPicture(BMP_NORELOAD, vbResBitmap)
    End If
    'Add icon to menu
    mcbMenuCommandBarCtrl.PasteFace
    'Very frankly, can you imagine a more awkward way of loading the icon?
    'The CommandBar control should have an adequate property or method
    
    'Set menu event handler
    Set MenuHandler = VBInstance.Events.CommandBarEvents(mcbMenuCommandBarCtrl)
    
    VBInstance.CommandBars("Tools").Controls(4).BeginGroup = True
    
End Sub

Private Sub IDTExtensibility_OnDisconnection(ByVal RemoveMode As vbext_DisconnectMode, custom() As Variant)

Dim sValue As String

    'Store current value of option before disconnection
    If gbRestore Then sValue = "1" Else sValue = "2"
    SaveSetting STR_APP, STR_SECTION, STR_KEY, sValue
    
    mcbMenuCommandBarCtrl.Delete
    
End Sub

Private Sub IDTExtensibility_OnStartupComplete(custom() As Variant)

Dim KeyValue As String
Dim AddInItem
Dim NewProjects
Dim Proj
Dim bPrompt As Boolean

    'Determine whether we load a default project
    bPrompt = True
    If GetKeyValue(HKEY_CURRENT_USER, STR_VB5, "PromptForProjectOnStartup", KeyValue) Then
        bPrompt = (KeyValue <> "0")
    End If
    
    'Exit if reloading not needed nor desired
    If (Not gbRestore) Or (bPrompt And (VBInstance.VBProjects.Count > 0)) Then Exit Sub
    
    'Get last project filename from registry
    If GetKeyValue(HKEY_CURRENT_USER, STR_VB5 & "\RecentFiles", "1", KeyValue) _
       And _
        FileExists(KeyValue) Then   ' Check file existence
        'Make an exclusive Add Project
        NewProjects = VBInstance.VBProjects.AddFromFile(KeyValue, True)
        
    End If

End Sub

Private Sub IDTExtensibility_OnAddInsUpdate(custom() As Variant)
'
End Sub

Private Sub MenuHandler_Click(ByVal CommandBarControl As Object, handled As Boolean, CancelDefault As Boolean)

    'Toggle option value
    gbRestore = Not gbRestore
    'Change menu item string and icon
    If gbRestore Then
        mcbMenuCommandBarCtrl.Caption = STR_NORELOAD
        Clipboard.SetData LoadResPicture(BMP_RELOAD, vbResBitmap)
    Else
        mcbMenuCommandBarCtrl.Caption = STR_RELOAD
        Clipboard.SetData LoadResPicture(BMP_NORELOAD, vbResBitmap)
    End If
    mcbMenuCommandBarCtrl.PasteFace
End Sub
